% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mzIDCollection.R
\docType{class}
\name{mzIDCollection-class}
\alias{[,mzIDCollection,character,missing,missing-method}
\alias{[,mzIDCollection,logical,missing,missing-method}
\alias{[,mzIDCollection,numeric,missing,missing-method}
\alias{[[,mzIDCollection,character,missing-method}
\alias{[[,mzIDCollection,numeric,missing-method}
\alias{as.list.mzIDCollection}
\alias{c,mzIDCollection-method}
\alias{database,mzIDCollection-method}
\alias{evidence,mzIDCollection-method}
\alias{files,mzIDCollection-method}
\alias{id,mzIDCollection-method}
\alias{idScanMap,mzIDCollection-method}
\alias{length,mzIDCollection-method}
\alias{modifications,mzIDCollection-method}
\alias{mzIDCollection-class}
\alias{names,mzIDCollection-method}
\alias{names<-,mzIDCollection,character-method}
\alias{parameters,mzIDCollection-method}
\alias{peptides,mzIDCollection-method}
\alias{removeDecoy,mzIDCollection-method}
\alias{scans,mzIDCollection-method}
\alias{show,mzIDCollection-method}
\alias{software,mzIDCollection-method}
\title{A class to handle a set of mzID objects}
\usage{
\S4method{show}{mzIDCollection}(object)

\S4method{length}{mzIDCollection}(x)

as.list.mzIDCollection(object)

\S4method{removeDecoy}{mzIDCollection}(object)

\S4method{names}{mzIDCollection}(x)

\S4method{names}{mzIDCollection,character}(x) <- value

\S4method{[[}{mzIDCollection,numeric,missing}(x, i, j, ...)

\S4method{[[}{mzIDCollection,character,missing}(x, i, j, ...)

\S4method{[}{mzIDCollection,numeric,missing,missing}(x, i, j, drop)

\S4method{[}{mzIDCollection,character,missing,missing}(x, i, j, drop)

\S4method{[}{mzIDCollection,logical,missing,missing}(x, i, j, drop)

\S4method{c}{mzIDCollection}(x, y, ..., recursive = FALSE)

\S4method{database}{mzIDCollection}(object, safeNames = TRUE)

\S4method{evidence}{mzIDCollection}(object, safeNames = TRUE)

\S4method{parameters}{mzIDCollection}(object)

\S4method{software}{mzIDCollection}(object)

\S4method{files}{mzIDCollection}(object)

\S4method{peptides}{mzIDCollection}(object, safeNames = TRUE)

\S4method{modifications}{mzIDCollection}(object)

\S4method{id}{mzIDCollection}(object, safeNames = TRUE)

\S4method{scans}{mzIDCollection}(object, safeNames = TRUE)

\S4method{idScanMap}{mzIDCollection}(object)
}
\arguments{
\item{object}{An mzIDCollection object}

\item{x}{An mzIDCollection object}

\item{value}{A character vector of desired names}

\item{i}{An integer or a string giving the index or the name respectively}

\item{j}{ignored}

\item{...}{ignored}

\item{drop}{ignored}

\item{y}{An mzID or mzIDCollection object}

\item{recursive}{ignored}

\item{safeNames}{Should column names be lowercased to ensure compatibility
between v1.0 and v1.1 files?}
}
\description{
This class is a container for multiple mzID objects. It is constructed such
that the bulk data are not copied when passed around. It is the aim that this
class have parity with the mzID class in the methods it exposes to the user, 
such that mzIDCollections can be thought of as vectors in the traditional R
sense. Furthermore it accepts standard indexing and concatenation.
}
\details{
Objects of this class is usually constructed be passing mulitple files to the
mzID constructor, or by combining mulitple mzID objects.
}
\section{Methods (by generic)}{
\itemize{
\item \code{show}: A short summary of the content of the object

\item \code{length}: Return the number of mzID object in the collection

\item \code{removeDecoy}: Removes decoys in all mzID object in collection

\item \code{names}: Get the names of the mzID object stored in the
collection

\item \code{names<-}: Set the names of the mzID object stored in the
collection

\item \code{[[}: Extract an mzID object by index

\item \code{[[}: Extract an mzID object by name

\item \code{[}: Subset collection by index

\item \code{[}: Subset collection by name

\item \code{[}: Subset collection by logical value

\item \code{c}: Combine mzIDCollction and mzID objects

\item \code{database}: Get the database used for searching

\item \code{evidence}: Get the evidence from the peptide search

\item \code{parameters}: Get the parameters used for the search

\item \code{software}: Get the software used to arrive at the results

\item \code{files}: Get the data files used for the analysis

\item \code{peptides}: Get the peptides identified.

\item \code{modifications}: Get the modification on the identified peptides

\item \code{id}: Get the identification results

\item \code{scans}: Get the scans matched to peptides

\item \code{idScanMap}: Get the link between scans and identifications
}}
\section{Slots}{

\describe{
\item{\code{data}}{An environment that holds the individual mzID objects}

\item{\code{.lookup}}{A matrix with indexing information for retriving the mzID 
objects in the @data slot.}
}}
\seealso{
\code{\link{mzID}} \code{\link{mzIDCollection}}

Other mzID.classes: \code{\link{mzID-class}},
  \code{\link{mzIDdatabase-class}},
  \code{\link{mzIDevidence-class}},
  \code{\link{mzIDparameters-class}},
  \code{\link{mzIDpeptides-class}},
  \code{\link{mzIDpsm-class}}
}

