% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotDistributions.R
\name{plotDistributions}
\alias{plotDistributions}
\title{Plot distribution of observed values}
\usage{
plotDistributions(
  se,
  selAssay = "counts",
  groupBy = NULL,
  plotType = "density",
  facet = FALSE,
  pseudocount = 0
)
}
\arguments{
\item{se}{A \code{SummarizedExperiment} object, typically generated by 
\code{summarizeExperiment()}.}

\item{selAssay}{Character scalar specifying the assay in \code{se} to 
use for the plotting.}

\item{groupBy}{Character scalar specifying a column from 
\code{colData(se)} to use for coloring or stratifying the plots.}

\item{plotType}{Character scalar specifying the type of plot to construct. 
Either \code{'density'}, \code{'histogram'} or \code{'knee'}.}

\item{facet}{Logical scalar, indicating whether or not to facet the plot
by the values specified in the \code{groupBy} column.}

\item{pseudocount}{Numeric scalar, representing the number to add to the 
observed values in the \code{selAssay} assay before plotting.}
}
\value{
A ggplot object.
}
\description{
Plot distribution of observed values
}
\examples{
se <- readRDS(system.file("extdata", "GSE102901_cis_se.rds", 
                          package = "mutscan"))[1:200, ]
plotDistributions(se)

}
\author{
Charlotte Soneson
}
