% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_musica.R
\name{subset_musica_by_counts}
\alias{subset_musica_by_counts}
\title{Creates a new musica subsetted to only samples with enough variants}
\usage{
subset_musica_by_counts(musica, table_name, num_counts)
}
\arguments{
\item{musica}{A \code{\linkS4class{musica}} object.}

\item{table_name}{Name of table used for subsetting}

\item{num_counts}{Minimum sum count value to drop samples}
}
\value{
Returns a new musica object with sample annotations, count tables,
and variants subsetted to only contains samples with the specified minimum
number of counts (column sums) in the specified table
}
\description{
Creates a new musica subsetted to only samples with enough variants
}
\examples{
data(musica_sbs96)
subset_musica_by_counts(musica_sbs96, "SBS96", 20)
}
