% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_result_model.R
\name{credible_intervals}
\alias{credible_intervals}
\alias{credible_intervals,musica-method}
\alias{credible_intervals,result_collection-method}
\alias{credible_intervals,result_model-method}
\alias{credible_intervals<-}
\alias{credible_intervals<-,musica,matrix-method}
\alias{credible_intervals<-,result_collection,matrix-method}
\alias{credible_intervals<-,result_model,matrix-method}
\title{Retrieve credible_intervals from a result_model, result_collection, or
musica object}
\usage{
credible_intervals(x, ...)

\S4method{credible_intervals}{musica}(x, result, modality, model_id)

\S4method{credible_intervals}{result_collection}(x, modality, model_id)

\S4method{credible_intervals}{result_model}(x)

credible_intervals(x, ...) <- value

\S4method{credible_intervals}{musica,matrix}(x, result, modality, model_id) <- value

\S4method{credible_intervals}{result_collection,matrix}(x, modality, model_id) <- value

\S4method{credible_intervals}{result_model,matrix}(x) <- value
}
\arguments{
\item{x}{A \code{\linkS4class{musica}},
\code{\linkS4class{result_collection}}, or \code{\linkS4class{result_model}}
object generated by a mutational discovery or prediction tool.}

\item{...}{Other inputs}

\item{result}{Name of result from result_list to assign the
credible_intervals. Used when \code{result} is a \code{\linkS4class{musica}}
object.}

\item{modality}{Modality to assign the credible_intervals. Used when
\code{result} is a \code{\linkS4class{musica}} or
\code{\linkS4class{result_collection}} object.}

\item{model_id}{Model identifier to assign the credible_intervals. Used when
\code{result} is a \code{\linkS4class{musica}} or
\code{\linkS4class{result_collection}} object.}

\item{value}{List of credible intervals}
}
\value{
The credible intervals for the model
}
\description{
Credible intervals for the model
}
\examples{
data(res)
credible_intervals(res, "result", "SBS96", "res")
}
