% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load_data.R
\name{create_musica_from_variants}
\alias{create_musica_from_variants}
\title{Creates a musica object from a variant table}
\usage{
create_musica_from_variants(
  x,
  genome,
  check_ref_chromosomes = TRUE,
  check_ref_bases = TRUE,
  chromosome_col = "chr",
  start_col = "start",
  end_col = "end",
  ref_col = "ref",
  alt_col = "alt",
  sample_col = "sample",
  extra_fields = NULL,
  standardize_indels = TRUE,
  convert_dbs = TRUE,
  verbose = TRUE
)
}
\arguments{
\item{x}{A data.table, matrix, or data.frame that contains columns with
the variant information.}

\item{genome}{A \linkS4class{BSgenome} object indicating which genome
reference the variants and their coordinates were derived from.}

\item{check_ref_chromosomes}{Whether to peform a check to ensure that
the chromosomes in the \code{variant} object match the reference
chromosomes in the \code{genome} object. If there are mismatches, this
may cause errors in downstream generation of count tables. If mismatches
occur, an attept to be automatically fix these with the
\code{\link[GenomeInfoDb]{seqlevelsStyle}} function will be made.
Default \code{TRUE}.}

\item{check_ref_bases}{Whether to check if the reference bases in the
\code{variant} object match the reference bases in the \code{genome}
object. Default \code{TRUE}.}

\item{chromosome_col}{The name of the column that contains the chromosome
reference for each variant. Default \code{"chr"}.}

\item{start_col}{The name of the column that contains the start
position for each variant. Default \code{"start"}.}

\item{end_col}{The name of the column that contains the end
position for each variant. Default \code{"end"}.}

\item{ref_col}{The name of the column that contains the reference
base(s) for each variant. Default \code{"ref"}.}

\item{alt_col}{The name of the column that contains the alternative
base(s) for each variant. Default \code{"alt"}.}

\item{sample_col}{The name of the column that contains the sample
id for each variant. Default \code{"sample"}.}

\item{extra_fields}{Which additional fields to extract and include in
the musica object. Default \code{NULL}.}

\item{standardize_indels}{Flag to convert indel style (e.g. `C > CAT`
becomes `- > AT` and `GCACA > G` becomes `CACA > -`)}

\item{convert_dbs}{Flag to convert adjacent SBS into DBS (original SBS are
removed)}

\item{verbose}{Whether to print status messages during error checking.
Default \code{TRUE}.}
}
\value{
Returns a musica object
}
\description{
This function creates a \linkS4class{musica} object from a variant
table or matrix. The \linkS4class{musica} class stores variants information,
variant-level annotations, sample-level annotations, and count tables and
is used as input to the mutational signature discovery and prediction
algorithms. The input variant table or matrix must have columns for
chromosome, start position, end position, reference allele,
alternate allele, and sample names. The column names in the variant table
can be mapped using the \code{chromosome_col}, \code{start_col},
\code{end_col}, \code{ref_col}, \code{alt_col}, and
\code{sample_col parameters}.
}
\examples{
maf_file <- system.file("extdata", "public_TCGA.LUSC.maf",
  package = "musicatk"
)
variants <- extract_variants_from_maf_file(maf_file)
g <- select_genome("38")
musica <- create_musica_from_variants(x = variants, genome = g)
}
