% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load_data.R
\name{create_musica_from_counts}
\alias{create_musica_from_counts}
\title{Creates a musica object from a mutation count table}
\usage{
create_musica_from_counts(x, variant_class)
}
\arguments{
\item{x}{A data.table, matrix, or data.frame that contains counts of mutation
types for each sample, with samples as columns.}

\item{variant_class}{Mutations are SBS, DBS, or Indel.}
}
\value{
Returns a musica object
}
\description{
This function creates a \linkS4class{musica} object from a mutation count
table or matrix. The \linkS4class{musica} class stores variants information,
variant-level annotations, sample-level annotations, and count tables and
is used as input to the mutational signature discovery and prediction
algorithms.
}
\examples{
data(musica)
count_table <- get_count_table(extract_count_tables(musica)$SBS96)
musica <- create_musica_from_counts(count_table, "SBS96")
}
