% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/computeCorrelations.R
\name{computeCorrelations}
\alias{computeCorrelations}
\alias{computeCorrelations,ANY-method}
\alias{computeCorrelations,SummarizedExperiment-method}
\title{Compute correlations between modes}
\usage{
computeCorrelations(x, y, ...)

\S4method{computeCorrelations}{ANY}(
  x,
  y,
  subset.cols = NULL,
  block = NULL,
  equiweight = TRUE,
  use.names = TRUE,
  BPPARAM = SerialParam()
)

\S4method{computeCorrelations}{SummarizedExperiment}(x, y, use.names = TRUE, ..., assay.type = "logcounts")
}
\arguments{
\item{x, y}{Normalized expression matrices containing features in the rows and cells in the columns.
Each matrix should have the same set of columns but a different set of features, usually corresponding to different modes for the same cells.

Alternatively, \linkS4class{SummarizedExperiment} objects containing such a matrix.

Finally, \code{y} may be \code{NULL}, in which correlations are computed between features in \code{x}.}

\item{...}{For the generic, further arguments to pass to specific methods.

For the SummarizedExperiment method, further arguments to pass to the ANY method.}

\item{subset.cols}{Vector indicating the columns of \code{x} (and \code{y}) to retain for computing correlations.}

\item{block}{A vector or factor of length equal to the number of cells, specifying the block of origin for each cell.}

\item{equiweight}{Logical scalar indicating whether each block should be given equal weight, if \code{block} is specified.
If \code{FALSE}, each block is weighted by the number of cells.}

\item{use.names}{Logical scalar specifying whether row names of \code{x} and/or \code{y} should be reported in the output, if available.

For the SummarizedExperiment method, this may also be a string specifying the \code{\link{rowData}} column containing the names to use;
or a character vector of length 2, where the first and second entries specify the \code{\link{rowData}} columns containing the names in \code{x} and \code{y} respectively.
If either entry is \code{NA}, the existing row names for the corresponding object are used.
Note that this only has an effect on \code{y} if it is a SummarizedExperiment.}

\item{BPPARAM}{A \linkS4class{BiocParallelParam} object specifying the parallelization scheme to use.}

\item{assay.type}{String or integer scalar specifying the assay containing the matrix of interest in \code{x} (and \code{y}, if a SummarizedExperiment).}
}
\value{
A DataFrame where each row corresponds to a pair of features in \code{x} and \code{y}.
(If \code{y=NULL}, each pair corresponds to a pair of features in \code{x}.)
This contains the following fields:
\itemize{
\item \code{feature1}, the name (character) or row index (integer) of each feature in \code{x}.
\item \code{feature2}, the name (character) or row index (integer) of one of the top correlated features to \code{feature1}.
This is another feature in \code{x} if \code{y=NULL}, otherwise it is a feature in \code{y}.
\item \code{rho}, the Spearman rank correlation for the current pair of \code{feature1} and \code{feature2}.
\item \code{p.value}, the approximate p-value associated with \code{rho} under the null hypothesis that the correlation is zero.
\item \code{FDR}, the adjusted p-value.
}
The rows are sorted by \code{feature1} and then \code{p.value}.
}
\description{
Compute Spearman correlations between two sets of features, using data collected for the same cells in different modalities.
}
\details{
If \code{block} is specified, correlations are computed separately for each block of cells.
For each feature pair, the reported \code{rho} is set to the average of the correlations across all blocks.
If \code{equiweight=FALSE}, the average is weighted by the number of cells in each block.

Similarly, the p-value corresponding to each correlation is computed separately for each block and then combined across blocks with Stouffer's method.
More specifically, combining is done using the one-sided p-values for both signs of the correlation, and the smaller p-value is taken (and multiplied by 2).
This ensures that a low p-value can only be achieved if the blocks agree in the sign.
If \code{equiweight=FALSE}, each per-block p-value is weighted by the number of cells.
}
\examples{
library(scuttle)
sce1 <- mockSCE()
sce1 <- logNormCounts(sce1)

sce2 <- mockSCE(ngenes=10) # pretend this is protein data.
sce2 <- logNormCounts(sce2)

output <- computeCorrelations(sce1, sce2)
output

}
\seealso{
\code{\link{findTopCorrelations}}, to avoid computing correlations for all pairs of features when \code{y} has many rows.
}
\author{
Aaron Lun
}
