% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_simulate.R
\name{qtleSimulate}
\alias{qtleSimulate}
\title{Create simulated multistateQTL data for testing purposes}
\usage{
qtleSimulate(
  params = qtleParams(),
  nTests = 100,
  nFeatures = NULL,
  nStates = 5,
  global = 0.5,
  multi = 0,
  unique = 0,
  k = 2,
  betaSd = 0.1,
  lfsr = TRUE,
  verbose = TRUE
)
}
\arguments{
\item{params}{list of parameters required to simulate betas and beta errors.
Generated by `qtleEstimate()` or `qtleParams()`.}

\item{nTests}{number of QTL tests}

\item{nFeatures}{number of QTL features to simulate tests for, NULL mean
nFeatures = nTests.}

\item{nStates}{number of states}

\item{global}{percent of QTL tests with significant effects shared across all
states}

\item{multi}{percent of QTL tests with significant effects shared across a
subset of states.}

\item{unique}{percent of QTL tests with significant effects in only one state}

\item{k}{number of multi-state clusters or an array with the cluster
assignments.}

\item{betaSd}{The desired standard deviation or an array of standard deviations
equal to the length of states for sampling beta values for each state.}

\item{lfsr}{Logical to calculate lfsr using mashr_1by1.}

\item{verbose}{Logical.}
}
\value{
A simulated `QTLExperiment` object.
}
\description{
Create simulated multistateQTL data for testing purposes
}
\details{
The simulation consists of user defined number of equal numbers of four different
types of effects: null, equal among conditions, present only in
first condition, independent across conditions
}
\examples{

qtleSimulate(nTests=100, nStates=5, global=0.1, multi=0.2, unique=0.05)

}
