% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_estimate.R
\name{qtleEstimate}
\alias{qtleEstimate}
\alias{qtleParams2}
\title{Estimate parameters from real data for simulating multi-state QTL summary statistics}
\usage{
qtleEstimate(
  data,
  assay = "pvalues",
  threshSig = 0.001,
  threshNull = 0.1,
  verbose = TRUE
)

qtleParams2()
}
\arguments{
\item{data}{A `QTLExperiment` object or named list containing "betas" and
"errors" matrices.}

\item{assay}{Assay containing test statistic information to use.}

\item{threshSig}{Max threshold (pval/lfsr) for calling tests as significant.}

\item{threshNull}{Min threshold (pval/lfsr) for calling tests as null.}

\item{verbose}{Logical.}
}
\value{
A list with parameter estimates for the QTLExperiment object.
}
\description{
Estimate parameters from real data for simulating multi-state QTL summary statistics
}
\details{
The simulation consists of user defined number of equal numbers of four different
types of effects: null, equal among conditions, present only in
first condition, independent across conditions
}
\examples{
qtle <- mockQTLE()
qtleEstimate(qtle)

}
