% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/07_count_offtargets.R
\name{index_targets}
\alias{index_targets}
\title{Index targets}
\usage{
index_targets(
  targets,
  bsgenome = getBSgenome(genome(targets)[1]),
  outdir = OUTDIR,
  verbose = TRUE
)
}
\arguments{
\item{targets}{\code{\link[GenomicRanges]{GRanges-class}}}

\item{bsgenome}{\code{\link[BSgenome]{BSgenome-class}}}

\item{outdir}{string: output directory}

\item{verbose}{TRUE (default) or FALSE}
}
\value{
invisible(targetdir)
}
\description{
Bowtie index targets
}
\examples{
require(magrittr)
bsgenome <- BSgenome.Mmusculus.UCSC.mm10::BSgenome.Mmusculus.UCSC.mm10
bedfile  <- system.file('extdata/SRF.bed', package = 'multicrispr')
targets <- extend(bed_to_granges(bedfile, genome = 'mm10'))
index_targets(targets, bsgenome)
}
