% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/07_count_offtargets.R
\name{index_genome}
\alias{index_genome}
\title{Index genome}
\usage{
index_genome(
  bsgenome,
  indexedgenomesdir = INDEXEDGENOMESDIR,
  download = TRUE,
  overwrite = FALSE
)
}
\arguments{
\item{bsgenome}{\code{\link[BSgenome]{BSgenome-class}}}

\item{indexedgenomesdir}{string: directory with bowtie-indexed genome}

\item{download}{TRUE (default) or FALSE: whether to download pre-indexed 
version if available}

\item{overwrite}{TRUE or FALSE (default)}
}
\value{
invisible(genomdir)
}
\description{
Bowtie index genome
}
\details{
Checks whether already available locally. If not, checks whether indexed
version can be downloaded from our s3 storage. If not, builds the
index with bowtie. This can take a few hours, but is a one-time operation.
}
\examples{
bsgenome <- BSgenome.Scerevisiae.UCSC.sacCer1::Scerevisiae
index_genome(bsgenome, indexedgenomesdir = tempdir())
}
