% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/06_find_primespacers.R
\name{extend_pe_to_gg}
\alias{extend_pe_to_gg}
\title{Extend prime editing target to find GG sites}
\usage{
extend_pe_to_gg(gr, nrt = 16, plot = FALSE)
}
\arguments{
\item{gr}{target \code{\link[GenomicRanges]{GRanges-class}}}

\item{nrt}{n RT nucleotides (default 16, recommended 10-16)}

\item{plot}{TRUE or FALSE (default)}
}
\value{
\code{\link[GenomicRanges]{GRanges-class}}
}
\description{
Extend prime editing target to find GG sites in accessible neighbourhood
}
\details{
Extends each target range to the area in which to search for a prime editing 
GG duplet, as shown in the sketch below.

                   ===============>
                             ----GG--------->
               ----GG--------->
                             **
               <---------GG---
                             <---------GG----
                         <===============
}
\examples{
# PE example
#-----------
    require(magrittr)
    bsgenome <- BSgenome.Hsapiens.UCSC.hg38::BSgenome.Hsapiens.UCSC.hg38  
    gr <- char_to_granges(c(PRNP = 'chr20:4699600:+',             # snp
                           HBB  = 'chr11:5227002:-',              # snp
                           HEXA = 'chr15:72346580-72346583:-',    # del
                           CFTR = 'chr7:117559593-117559595:+'),  # ins
                          bsgenome)
    extend_pe_to_gg(gr, plot = TRUE)
}
