% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/05_manipulate_ranges.R
\name{add_inverse_strand}
\alias{add_inverse_strand}
\title{Add inverse strand}
\usage{
add_inverse_strand(gr, verbose = FALSE, plot = FALSE, ...)
}
\arguments{
\item{gr}{\code{\link[GenomicRanges]{GRanges-class}}}

\item{verbose}{TRUE or FALSE (default)}

\item{plot}{TRUE or FALSE (default)}

\item{...}{\code{\link{plot_intervals}} arguments}
}
\value{
\code{\link[GenomicRanges]{GRanges-class}}
}
\description{
Add inverse strand
}
\examples{
# PE example
#-----------
    require(magrittr)
    bsgenome <- BSgenome.Hsapiens.UCSC.hg38::BSgenome.Hsapiens.UCSC.hg38  
    gr <- char_to_granges(c(PRNP = 'chr20:4699600:+',             # snp
                            HBB  = 'chr11:5227002:-',             # snp
                            HEXA = 'chr15:72346580-72346583:-',   # del
                            CFTR = 'chr7:117559593-117559595:+'), # ins
                          bsgenome)
    add_inverse_strand(gr, plot = TRUE)
# TFBS example
#-------------
    bedfile <- system.file('extdata/SRF.bed', package='multicrispr')
    gr <- bed_to_granges(bedfile, genome = 'mm10')
    add_inverse_strand(gr)
}
