% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diffModuleExpAnalysis.R
\name{moduleExpressionPlot}
\alias{moduleExpressionPlot}
\title{Plots an expression profile for a module}
\usage{
moduleExpressionPlot(
  WGCNAobject,
  geneList,
  mode = c("PC1", "averageZscore"),
  legend = FALSE,
  title = NULL,
  clusterGenes = FALSE
)
}
\arguments{
\item{WGCNAobject}{an object of class WGCNAobject}

\item{geneList}{a vector of gene names to be extracted from WGCNAobject}

\item{mode}{use first principal component or averageZscore?}

\item{legend}{plot legend?}

\item{title}{title of the plot}

\item{clusterGenes}{cluster heatmap genes by hierarchical clustering?}
}
\value{
a patchworked ggplot object
}
\description{
A plotting function that returns a heatmap and barplot for a module
}
\examples{
library(ExperimentHub)
eh = ExperimentHub()
eh_query = query(eh, c("multiWGCNAdata"))
astrocyte_networks = eh_query[["EH8222"]]
moduleExpressionPlot(astrocyte_networks[["combined"]], 
  geneList = topNGenes(astrocyte_networks$combined, "combined_013"))

}
\author{
Dario Tommasini
}
