% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generalFunctions.R
\name{makeTraitTable}
\alias{makeTraitTable}
\title{Generate a trait table from a sample table}
\usage{
makeTraitTable(inputTable, column, detectNumbers = FALSE)
}
\arguments{
\item{inputTable}{the sampleTable data.frame}

\item{column}{the column from the sampleTable to use as traits}

\item{detectNumbers}{whether to consider traits with numbers as numerical rather than categorical variables}
}
\value{
a data.frame with integer values denoting the categorical sample traits
}
\description{
Generates a WGCNA-compatible trait table from a sampleTable dataframe
}
\examples{
sampleTable = data.frame(Sample = c(paste0("EAE", 1:10), paste0("WT", 1:10)), 
                         Disease = c(rep("EAE", 10), rep("WT", 10)), 
                         Region = c(rep(c("Cbl", "Sc"), 5))) 
makeTraitTable(sampleTable, 2)

}
