% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preservation.R
\name{coexpressionLineGraph}
\alias{coexpressionLineGraph}
\title{Coexpression Line Graph}
\usage{
coexpressionLineGraph(datExpr, splitBy = 1, fontSize = 2.15, colors = NULL)
}
\arguments{
\item{datExpr}{a data.frame with genes as rows and samples as columns}

\item{splitBy}{how much to split genes by on line graph}

\item{fontSize}{the font size of the gene labels}

\item{colors}{a vector of colors; default is random colors generated by colors function}
}
\value{
a ggplot object
}
\description{
Plots a line graph showing the co-expression of selected genes across samples
}
\examples{
library(ExperimentHub)
eh = ExperimentHub()
eh_query = query(eh, c("multiWGCNAdata"))
astrocyte_networks = eh_query[["EH8222"]]
datExpr = GetDatExpr(astrocyte_networks[[1]], 
  genes = topNGenes(astrocyte_networks$EAE, "EAE_015", 20))
coexpressionLineGraph(datExpr)	+ 
  geom_vline(xintercept = 20.5, linetype='dashed')

}
\author{
Dario Tommasini
}
