% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/overlaps.R
\name{bidirectionalBestMatches}
\alias{bidirectionalBestMatches}
\title{Best matching modules}
\usage{
bidirectionalBestMatches(comparisonList, plot = TRUE)
}
\arguments{
\item{comparisonList}{a list with an elemnt "overlap", which is a data.frame resulting from a call to computeOverlapsFromWGCNA}

\item{plot}{whether to generate a heatmap; default is TRUE}
}
\value{
A ggplot object
}
\description{
Find all the modules from dataset1 that have a best match to a module in dataset2
if that module in dataset2 is also a best match to the module in dataset1
}
\examples{
library(ExperimentHub)
eh = ExperimentHub()
eh_query = query(eh, c("multiWGCNAdata"))
astrocyte_networks = eh_query[["EH8222"]]
comparisonList = list()
comparisonList$overlaps = computeOverlapsFromWGCNA(astrocyte_networks$EAE, astrocyte_networks$WT)
bidirectionalBestMatches(comparisonList)

}
\author{
Dario Tommasini
}
