% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dbinfo.R
\name{multimir_dbInfo}
\alias{multimir_dbInfo}
\alias{multimir_dbCount}
\alias{multimir_dbInfoVersions}
\alias{multimir_dbSchema}
\alias{multimir_dbTables}
\alias{multimir_dbInfoVersions}
\alias{multimir_dbSchema}
\alias{multimir_dbTables}
\alias{multimir_dbCount}
\title{Collect Information About the Web Server And Database of the multiMiR
Package}
\usage{
multimir_dbInfo(url = NULL)

multimir_dbInfoVersions(url = NULL)

multimir_dbSchema(schema.file = NULL)

multimir_dbTables(url = NULL)

multimir_dbCount(url = NULL)
}
\arguments{
\item{url}{Deprecated. Use global option \code{multimir.url} instead.}

\item{schema.file}{Deprecated. Option exists as \code{multimir.schema},
but it should not need to be set directly.}
}
\value{
\code{multimir_dbCount}: a data frame with the count of records in
each of the tables in the multiMiR database.

\code{multimir_dbInfo}: a data frame with information about the multiMiR
database.

\code{multimir_dbInfoVersions}: a data frame with information about the
multiMiR database versions.

\code{multimir_dbSchema}: none (invisible \code{NULL}).

\code{multimir_dbTables}: a data frame with table names in the multiMiR
database.
}
\description{
Functions for collecting and displaying information about the web server and
database of the multiMiR package.
}
\details{
\code{multimir.url} is a global option containing the URL of the multiMiR web
server. Set using \code{options("multimir.url" = ...)}

\code{multimir_dbCount} returns counts of records in the tables in the
multiMiR database. Each table contains data from an external miRNA/target
database.

\code{multimir_dbInfo} returns other information about the multiMiR
database. This includes information of external miRNA/target databases in
multiMiR.

\code{multimir_dbInfoVersions} returns other information about the multiMiR
database versions available. This provides a list of available options if
switching to previous version is desired.

\code{multimir_dbSchema} prints the schema definition of the multiMiR
database.

\code{multimir_dbTables} returns the vector of tables in the multiMiR
database and saves it to the global option \code{multimir.tables.list}. This
function is automatically run when get_multimir is called if the
\code{multimir.tables.list} is NULL.
}
\examples{

  this_url <- getOption("multimir.url")
  this_url
  options(multimir.url = this_url)
  
  db_ver <- multimir_dbInfoVersions()
  
  db_count <- multimir_dbCount()

  db_info <- multimir_dbInfo()

  multimir_dbSchema()

  db_tables <- multimir_dbTables()

}
\keyword{database}
\keyword{utilities}
