% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/listdata.R
\name{list_multimir}
\alias{list_multimir}
\alias{list.multimir}
\title{List microRNAs, Genes, Drugs Or Diseases in the multiMiR Package}
\usage{
list_multimir(x = c("mirna", "gene", "drug", "disease"), limit = NULL,
  url = NULL)

list.multimir(x = c("mirna", "gene", "drug", "disease"), limit = NULL,
  url = NULL)
}
\arguments{
\item{x}{a character string indicating what to list. This must be one of the
strings \code{"mirna"} (default), \code{"gene"}, \code{"drug"}, or
\code{"disease"}. This can be abbreviated and is case insensitive.}

\item{limit}{a positive integer. Limits the number of records returned from
each table.  Useful in testing potentially large queries.}

\item{url}{Deprecated. Use global option \code{multimir.url} instead.}
}
\value{
\code{list_multimir} returns a data frame with information of
microRNAs (microRNA unique ID, organism, mature microRNA accession number,
and mature microRNA ID), target genes (gene unique ID, organism, gene
symbol, Entrez gene ID, and Ensembl gene ID), drugs (drug names), and
diseases (disease name).
}
\description{
\code{list_multimir} lists all the unique microRNAs, target genes, drugs, or
diseases in the web server of the multiMiR package.
}
\details{
list.multimir() has been deprecated and replaced with the list_multimir()
version.
}
\examples{
  miRNAs <- list_multimir("mirna", limit = 10)
  genes <- list_multimir("gene", limit = 10)
  drugs <- list_multimir("drug", limit = 10)
  diseases <- list_multimir("disease", limit = 10)
}
\author{
Yuanbin Ru \email{ruyuanbin@gmail.com}
}
\keyword{database}
\keyword{utilities}
