% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tabletypes.R
\name{all_tables}
\alias{all_tables}
\alias{all_tables,}
\alias{validated_tables,}
\alias{predicted_tables,}
\alias{diseasedrug_tables,}
\alias{tables_wo_target,}
\alias{reverse_table_lookup}
\alias{validated_tables}
\alias{predicted_tables}
\alias{diseasedrug_tables}
\alias{tables_wo_target}
\alias{conserved_tables}
\alias{reverse_table_lookup}
\alias{table_types}
\title{Functions defining the category each table belongs to.}
\usage{
all_tables()

validated_tables()

predicted_tables()

diseasedrug_tables()

tables_wo_target()

conserved_tables()

reverse_table_lookup(.table)

table_types()
}
\arguments{
\item{.table}{a table name}
}
\value{
Returns dataset that names that belong to the category of the
function name (e.g. \code{validated_tables()} returns tables with validated
miRNA-target interactions).  \code{reverse_table_lookup()} does the opposite;
it returns the category a given \code{.table} belongs to.
}
\description{
One of three types: predicted, validated, or diseasedrug.
Additionally two functions define characteristics of tables: those without a
target column \code{tables_wo_target} and those with conserved target sites
\code{conserved_tables}.
}
\examples{
all_tables()
validated_tables()
predicted_tables()
diseasedrug_tables()
predicted_tables() \%in\% all_tables() # TRUE
table_types()

}
\keyword{tables}
