% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/perm_test.R
\name{perm_test}
\alias{perm_test}
\title{Perform a permutation test to check enrichment of a genomic
    feature with DIRs detected by multiHiCcompare}
\usage{
perm_test(
  hicexp,
  feature,
  p.adj_cutoff = 10^-10,
  logfc_cutoff = 1,
  num.perm = 1000,
  pval_aggregate = "max"
)
}
\arguments{
\item{hicexp}{A Hicexp object which has been compared.}

\item{feature}{A GRanges object containing locations for
a genomic feature you would like to test for enrichment
in the differentially interacting regions (DIRs).}

\item{p.adj_cutoff}{The adjusted p-value cutoff for
declaring a region significant. See ?topDirs for
more information. Defaults to 10^-10}

\item{logfc_cutoff}{The log fold change cutoff for
a region to be declared significant. See ?topDirs
for more information. Defaults to 1.}

\item{num.perm}{The number of permutations to run.
Defaults to 1000.}

\item{pval_aggregate}{Method to aggregate region-specific p-values.
If a region differentially interacts with several other regions,
the p-values are aggregated using a 'max' method (Default, select maximum
p-value, most conservative), or the Fisher ('fisher'), Lancaster ('lancaster'),
or Sidak ('sidak') methods (see 'aggregate' package).
regions, it is assigned a single p-value aggregated from several. See ?topDirs}
}
\value{
The permutation p-value
}
\description{
Perform a permutation test to check enrichment of a genomic
    feature with DIRs detected by multiHiCcompare
}
\examples{
\dontrun{
data("hicexp_diff")
data("hg19_cyto")
perm_test(hicexp_diff, hg19_cyto)
}
}
