% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/feature_processing.R
\name{getMetaboliteMapping}
\alias{getMetaboliteMapping}
\title{Mapping between pathway encoded metabolites and different metabolite ID
formats.}
\usage{
getMetaboliteMapping(features, keytype, returntype = "HMDB")
}
\arguments{
\item{features}{List of identifiers to be mapped.}

\item{keytype}{String specifying the ID type, e.g., "ChEBI" or "KEGGCOMP".}

\item{returntype}{String that specifies the returning ID type.
Default: HMDB
Options: HMDB, CAS, DTXCID, DTXSID, SID, CID, ChEBI, KEGG, Drugbank}
}
\value{
List containing mapped gene/protein IDs.
}
\description{
Function to retrieve the metabolite identifier mapping. Ongoing from
metabolites retrieved from pathway definitions, which often include two or
more ID formats, this function maps those IDs to a given format. The complete
mapping table based on \href{https://comptox.epa.gov/dashboard}{Comptox
Dashboard}, \href{https://pubchem.ncbi.nlm.nih.gov/}{PubChem},
\href{https://hmdb.ca/}{HMDB}, and \href{https://www.ebi.ac.uk/chebi}{ChEBI}
is provided in the AnnotationHub package metaboliteIDmapping.
}
\examples{
features <- graphite::nodes(graphite::pathways("hsapiens", "kegg")[[1]], which = "metabolites")
features <- gsub("KEGGCOMP:", "", features)
keytype <- "KEGG"

getMetaboliteMapping(features, keytype)

getMetaboliteMapping(features, keytype = "KEGG", returntype = "CID")

}
