% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enrichment_functions.R
\name{extractPvalues}
\alias{extractPvalues}
\title{Create a reshaped data frame from multiGSEA output.}
\usage{
extractPvalues(enrichmentScores, pathwayNames)
}
\arguments{
\item{enrichmentScores}{Nested List of enrichment scores, calculated by
multiGSEA function.}

\item{pathwayNames}{List containing Pathway names.}
}
\value{
Data frame where rows are pathways and columns are (adjusted)
  p-values for each omics layer.
}
\description{
This function reshapes the output from multiGSEA to get a single data frame
with columns for p-values and adjusted p-values for each omics layer. Each
row of the data frame represents one pathway.
}
\examples{
# Download pathway definition and extract features
pathways <- getMultiOmicsFeatures(dbs = c("kegg"), layer = c("transcriptome", "proteome"))

# load omics data and calculate ranks
data(transcriptome)
data(proteome)
ranks <- initOmicsDataStructure(c("transcriptome", "proteome"))
ranks$transcriptome <- rankFeatures(transcriptome$logFC, transcriptome$pValue)
names(ranks$transcriptome) <- transcriptome$Symbol
ranks$proteome <- rankFeatures(proteome$logFC, proteome$pValue)
names(ranks$proteome) <- proteome$Symbol

# run the enrichment
es <- multiGSEA(pathways, ranks)

extractPvalues(
  enrichmentScores = es,
  pathwayNames = names(pathways[[1]])
)
}
