% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WriteMatrixToFile.R
\name{WriteMatrixToFile}
\alias{WriteMatrixToFile}
\title{Function to write a data matrix to a text file.}
\usage{
WriteMatrixToFile(tmpMatrix, tmpFileName, blnRowNames, blnColNames)
}
\arguments{
\item{tmpMatrix}{The object matrix containing data.}

\item{tmpFileName}{The string name of the text file to write the matrix to.}

\item{blnRowNames}{Logical value indicating if row names of the matrix
should be written along with the matrix.}

\item{blnColNames}{Logical value indicating if the column names of the
matrix should be written with the matrix.}
}
\value{
Text file containing the data matrix.
}
\description{
Function to write a data matrix to a text file.
}
\examples{

#Load sample dataset
data(iris)
# View sample matrix
iris[1:4, 1:4]
# Write sample matrix to text file
WriteMatrixToFile(tmpMatrix=iris, tmpFileName="iris.sample.matrix.txt",
blnRowNames=TRUE, blnColNames=TRUE)

}
\author{
Peiyong Guan
}
\seealso{
\code{\link[utils]{write.table}}
}

