% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/StatModel-methods.R
\name{getContrast,StatModel-method}
\alias{getContrast,StatModel-method}
\alias{statModelMethods}
\alias{StatModel-method}
\alias{getContrast}
\alias{varContrast}
\alias{varContrast,StatModel-method}
\title{Methods for StatModel class}
\usage{
\S4method{getContrast}{StatModel}(object, L)

\S4method{varContrast}{StatModel}(object, L)
}
\arguments{
\item{object}{A list with elements of the class \code{StatModel} that are
estimated using the \code{\link{msqrob}} function}

\item{L}{contrast \code{numeric} matrix specifying one or more contrasts of
the linear model coefficients to be tested equal to zero.
The rownames of the matrix should be equal to the names of
parameters of the model.}
}
\value{
A matrix with the calculated contrasts or variance-covariance matrix of contrasts
}
\description{
Methods for StatModel class
\describe{
\item{getContrast(object, L)}{to calculate contrasts of the model parameters}
\item{varContrast(object, L)}{to calculate the variance-covariance matrix of the contrasts}
}
}
\examples{
data(pe)
# Aggregate peptide intensities in protein expression values
pe <- aggregateFeatures(pe, i = "peptide", fcol = "Proteins", name = "protein")

# Fit msqrob model
pe <- msqrob(pe, i = "protein", formula = ~condition)

# Define contrast
getCoef(rowData(pe[["protein"]])$msqrobModels[[1]])
# Define contrast for log2 fold change between condition c and condition b:
L <- makeContrast("conditionc - conditionb=0", c("conditionb", "conditionc"))

getContrast(rowData(pe[["protein"]])$msqrobModels[[1]], L)
varContrast(rowData(pe[["protein"]])$msqrobModels[[1]], L)
}
