% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/msqrob.R
\name{msqrobGlm}
\alias{msqrobGlm}
\title{Function to fit msqrob models to peptide counts using glm}
\usage{
msqrobGlm(y, npep, formula, data, priorCount = 0.1, binomialBound = TRUE)
}
\arguments{
\item{y}{A \code{matrix} with the peptide counts. The
features are along the rows and samples along the columns.}

\item{npep}{A vector with number of peptides per protein. It has as length
the number of rows of y. The counts are equal or larger than the largest
peptide count in y.}

\item{formula}{Model formula. The model is built based on the
covariates in the data object.}

\item{data}{A \code{DataFrame} with information on the design. It has
the same number of rows as the number of columns (samples) of
\code{y}.}

\item{priorCount}{A 'numeric(1)', which is a prior count to be added to the observations to shrink
the estimated log-fold-changes towards zero.}

\item{binomialBound}{logical, if ‘TRUE’ then the quasibinomial variance estimator will
be never smaller than 1 (no underdispersion).}
}
\value{
A list of objects of the \code{StatModel} class.
}
\description{
Low-level function for parameter estimation with msqrob
by modeling peptide counts using quasibinomial glm
}
\examples{

# Load example data
# The data are a Feature object with containing
# a SummarizedExperiment named "peptide" with MaxQuant peptide intensities
# The data are a subset of spike-in the human-ecoli study
# The variable condition in the colData of the Feature object
# contains information on the spike in condition a-e (from low to high)
data(pe)

# Aggregate peptide intensities in protein expression values
pe <- aggregateFeatures(pe, i = "peptide", fcol = "Proteins", name = "protein")
pe

# Fit MSqrob model using robust regression with the MASS rlm function
models <- msqrobGlm(
    aggcounts(pe[["protein"]]),
    rowData(pe[["protein"]])[[".n"]],
    ~condition,
    colData(pe)
)
getCoef(models[[1]])
}
\author{
Lieven Clement
}
