% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{merge_slp}
\alias{merge_slp}
\title{Merge SLPs}
\usage{
merge_slp(comp_data, corr_data)
}
\arguments{
\item{comp_data}{predicted SLPs from \code{\link{comp_slp}}.}

\item{corr_data}{predicted SLPs from \code{\link{corr_slp}}.}
}
\value{
A data.table.
  \describe{
    \item{mut_entrez}{Entrez ids of mutations.}
    \item{mut_symbol}{Gene symbols of mutations.}
    \item{slp_entrez}{Entrez ids of SLPs.}
    \item{slp_symbol}{Gene symbols of SLPs.}
    \item{pvalue}{p_value from \code{\link[RankProd]{RankProducts}}.}
    \item{fdr}{"BH" adjusted pvalue via \code{\link[stats]{p.adjust}}.}
    \item{im}{The importance value returned by \code{\link{genie3}}.}
    \item{dualhit}{Whether the slp is identified by \code{\link{corr_slp}} and \code{\link{comp_slp}}.}
}
}
\description{
Merge predcted SLPs from comp_slp and corr_slp.
}
\examples{
data("example_z")
data("example_comp_mut")
comp_res <- comp_slp(example_z, example_comp_mut)

data("example_expr")
data("example_corr_mut")
corr_res <- corr_slp(example_expr, example_corr_mut)

res <- merge_slp(comp_res, corr_res)
}
