% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genie3.R
\name{getlink}
\alias{getlink}
\title{Get sorted list of regulatory links in GENIE3 results}
\usage{
getlink(weight.matrix, report.max = NULL)
}
\arguments{
\item{weight.matrix}{a weighted adjacency matrix as returned by genie3.}

\item{report.max}{maximum number of links to report (default all links).}
}
\value{
A data.table of links with columns "from.gene", "to.gene", "im".
}
\description{
Take genie3 output and sort the links.
}
\examples{
mtx <- matrix(sample(1000, 100), nrow = 5)
mtx <- rbind(mtx[1, ] * 2 + rnorm(20), mtx)
colnames(mtx) <- paste0("s_", seq_len(ncol(mtx)))
rownames(mtx) <- paste0("g_", seq_len(nrow(mtx)))
res <- genie3(mtx, nb.trees = 10)
res_link <- getlink(res)
}
