% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{est_im}
\alias{est_im}
\title{Estimate the importance threshold for GENIE3}
\usage{
est_im(permu_data, fdr_thresh = 0.001)
}
\arguments{
\item{permu_data}{permuated \code{\link{corr_slp}} results.}

\item{fdr_thresh}{fdr threshold to selected "TRUE" SLPs.}
}
\value{
A data.table with mut_entrez (mutation entrez_id) and roc_thresh (estimated im threshold).
}
\description{
Estimate the importance threshold based on repetition GENIE3 results via ROC.
}
\details{
We first generate a SLPs by repetition matrix from repetition GENIE3 results.
  SLPs with high im value in repetitions are selected and condsidered as "TRUE" SLPs via the rank product algorithm.
  Then for each repetion, we perform receiver operating characteristic curve analysis and select an optimal threshold by "youden" approach.
  The optimal thresholds are averaged to get the final threshold.
}
\examples{
#- Toy examples.
require(future)
require(doFuture)
plan(multisession, workers = 2)
data(example_expr)
data(example_corr_mut)
mutgene    <- sample(intersect(example_corr_mut$mut_entrez, rownames(example_expr)), 2)
nperm      <- 5
res        <- lapply(seq_len(nperm), function(x) corr_slp(example_expr,
                      example_corr_mut, mutgene = mutgene))
roc_thresh <- est_im(res)
plan(sequential)
}
