% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/correlationSLP.R
\name{corr_slp}
\alias{corr_slp}
\title{Identify SLPs via correlation}
\usage{
corr_slp(
  expr_data,
  mut_data,
  mutgene = NULL,
  im_thresh = 0.001,
  topgene = 2000,
  ...
)
}
\arguments{
\item{expr_data}{an expression matrix, genes by patients.}

\item{mut_data}{a data.table with columns "patientid" and "mut_entrez".}

\item{mutgene}{identify SLPs for sepecific muatation (gene symbols). If NULL (by default), the intersection genes between expr_data and mut_data are used.}

\item{im_thresh}{minimum importance threshold.}

\item{topgene}{top N genes above the \code{im_thresh}.}

\item{...}{further parameters to \code{\link{genie3}}.}
}
\value{
A data.table with predicted SLPs.
  \describe{
    \item{mut_entrez}{Entrez ids of mutations.}
    \item{mut_symbol}{Gene symbols of mutations.}
    \item{slp_entrez}{Entrez ids of SLPs.}
    \item{slp_symbol}{Gene symbols of SLPs.}
    \item{fdr}{"BH" adjusted pvalue via \code{\link[stats]{p.adjust}}.}
    \item{im}{The importance value returned by \code{\link{genie3}}.}
}
}
\description{
Identify SLPs of mutations based on co-expression. GENIE3 is employed to
find genes highly correlated with mutations in wide type patients.
}
\examples{
#- Toy examples, see vignette for more.
require(future)
require(doFuture)
plan(multisession, workers = 2)
data("example_expr")
data("example_corr_mut")
res <- corr_slp(example_expr, example_corr_mut)
plan(sequential)
}
