% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkCuts.R
\name{checkCuts}
\alias{checkCuts}
\title{checkCuts}
\usage{
checkCuts(cutSites, genome, fasta = FALSE, seq)
}
\arguments{
\item{cutSites}{A GRanges object containing the locations of the cut sites to be checked for sequence match. The names of the correct cut sites will be returned as a GRanges object.}

\item{genome}{The path to a fasta file or a BSgenome object to check for genomic sequences.}

\item{fasta}{TRUE if a fasta file has been supplied. Default = FALSE}

\item{seq}{The desired recognition sequence that the enzyme should have cut.}
}
\value{
A GRanges object containing the names of the sites that had the correct sequence.
}
\description{
Determines the sequence around a cut site using a fasta file or BSgenome
}
\examples{
library(GenomicRanges)
library(SummarizedExperiment)
library(BSgenome.Rnorvegicus.UCSC.rn6)
# Load the positions of possible MspI cut sites
data(ratdata)
# Extract the cut sites
cutSites <- rowRanges(ratdata)
# Adjust the cut sites to overlap recognition site on each strand
start(cutSites) <- ifelse(test = strand(cutSites) == '+',
                          yes = start(cutSites) - 1, no = start(cutSites) - 2)
end(cutSites) <- ifelse(test = strand(cutSites) == '+',
                        yes = end(cutSites) + 2, no = end(cutSites) + 1)
correctCuts <- checkCuts(cutSites = cutSites, genome = "rn6", seq = "CCGG")
}
\author{
Benjamin Mayne
}

