% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iw-norm.R
\name{iwNormQE.5}
\alias{iwNormQE.5}
\title{Q-Exactive +/- 0.5 range, normalisation for isolation window efficiency}
\usage{
iwNormQE.5()
}
\value{
normalisation function for +/- 0.5 range for Q-Exactive
}
\description{
Creates a function based on a previous experimental analysis of a Q-Exactive at +/- 0.5
isolation window efficiency. See http://pubs.acs.org/doi/abs/10.1021/acs.analchem.6b04358

The function that is created will output a value between 0 to 1 based on the position between
the minOff and maxOff params

NOTE: The resulting function will work for values greater that 0.5 and less than -0.5.

This is because (on our instrument tested at least) when using a window of +/- 0.5,
the isolation is NOT confined to the +/-0.5 Da window. Resulting in ions from outside the window
being isolated. For this reason the function can normalise values outside of the
the +/- 1 Da range. Please see above paper figure 3 for more details.
}
\examples{
iwNormFun <- iwNormQE.5()
pm <- data.frame(mz=c(99.5, 99.9, 100, 100.1, 100.5),i=c(1000, 1000, 1000, 1000, 1000))
mzmax = 100.5
mzmin = 99.5
middle <- mzmax-(mzmax-mzmin)/2
adjustmz = pm$mz-middle

# normalise the intensities
pm$normi = pm$i*iwNormFun(adjustmz)

}
