% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/purityA-frag4feature.R
\name{frag4feature,purityA-method}
\alias{frag4feature,purityA-method}
\alias{frag4feature}
\title{Using a purityA object, link MS/MS data to XCMS features}
\usage{
\S4method{frag4feature}{purityA}(
  pa,
  xcmsObj,
  ppm = 5,
  plim = NA,
  intense = TRUE,
  convert2RawRT = TRUE,
  useGroup = FALSE,
  createDb = FALSE,
  outDir = ".",
  dbName = NA,
  grpPeaklist = NA,
  use_group = NA,
  out_dir = NA,
  create_db = NA,
  grp_peaklist = NA,
  db_name = NA,
  xset = NA
)
}
\arguments{
\item{pa}{object; purityA object}

\item{xcmsObj}{object; XCMSnExp, xcmsSet or xsAnnotate object derived from the same files as those used to create the purityA object}

\item{ppm}{numeric; ppm tolerance between precursor mz and XCMS feature mz}

\item{plim}{numeric; minimum purity of precursor to be included}

\item{intense}{boolean; If TRUE the most intense precursor will be used. If FALSE the precursor closest to the center of the isolation window will be used}

\item{convert2RawRT}{boolean; If retention time correction has been used in XCMS set this to TRUE}

\item{useGroup}{boolean; Ignore individual peaks and just find matching fragmentation spectra within the (full) rtmin rtmax of each grouped feature}

\item{createDb}{boolean; if yes, generate a database of MS2 spectra}

\item{outDir}{string; path where (optionally generated) database file should be saved}

\item{dbName}{character; name to assign to (optionally exported) database.}

\item{grpPeaklist}{dataframe; Can use any peak dataframe to add to databse. Still needs to be derived from the "obj" object though}

\item{use_group}{boolean; (Deprecated, to be removed - replaced with useGroup argument for style consistency)}

\item{out_dir}{character; (Deprecated, to be removed - use createDatabase function) Path where database will be created}

\item{create_db}{boolean; (Deprecated, to be removed - use createDatabase function) SQLite database will be created of the results}

\item{grp_peaklist}{dataframe; (Deprecated, to be removed - use createDatabase function) Can use any peak dataframe to add to databse. Still needs to be derived from the xset object though}

\item{db_name}{character; (Deprecated, to be removed - use createDatabase function) If create_db is TRUE, a custom database name can be used, default is a time stamp}

\item{xset}{object; (Deprecated, to be removed - use xcmsObj) 'xcmsSet' object derived from the same files as those used to create the purityA object}
}
\value{
Returns a purityA object (pa) with the following slots populated:
\itemize{
\item pa@grped_df: A dataframe of the grouped XCMS features linked to the associated fragmentation spectra precursor details is recorded here
\item pa@grped_ms2: A list of fragmentation spectra associated with each grouped XCMS feature is recorded here
\item pa@f4f_link_type: The linking method is recorded here (e.g. individual peaks or grouped - "useGroup=TRUE")
}
}
\description{
\subsection{General}{

Assign fragmentation spectra (MS/MS) stored within a purityA class object to grouped features within an XCMS xset object.

XCMS calculates individual chromatographic peaks for each mzML file (retrieved using xcms::chromPeaks(xcmsObj)), these are then grouped together
(using xcms::groupChromPeaks). Ideally the mzML files that contain the MS/MS spectra also contain sufficient MS1 scans for XCMS to detect
MS1 chromatographic features. If this is the case, to determine if a MS2 spectra is to be linked to an XCMS grouped feature,
the associated acquisition time of the MS/MS event has to be within the retention time window defined for the individual peaks
associated for each file. The precursor m/z value also has to be within the user ppm tolerance to XCMS feature.

See below for representation of the linking (the * ------ * represent a many-to-many relationship) e.g. 1 or more MS/MS events can be
linked to 1 or more individual feature and an individual XCMS feature can be linked to 1 or more grouped XCMS features
\itemize{
\item [grouped XCMS feature - across files] * ------ *  [individual XCMS feature - per file] * ------ *  [MS/MS spectra]
}

Alternatively, if the "useGroup" argument is set to TRUE, the full width of the grouped peak (determined as the minimum rtmin
and maximum rtmax of the all associated individual peaks) will be used. This option should be used if the mzML file with
MS/MS has very limited MS1 data and so individual chromatographic peaks might not be detected with the mzML files containing the
MS/MS data. However, it should be noted this may lead to potential inaccurate linking.
\itemize{
\item [grouped XCMS peaks] * ------ * [MS/MS spectra]
}
}

\subsection{Example LC-MS/MS processing workflow}{
\itemize{
\item Purity assessments
\itemize{
\item (mzML files) -> purityA -> (pa)
}
\item XCMS processing
\itemize{
\item (mzML files) -> xcms.findChromPeaks -> (optionally) xcms.adjustRtime -> xcms.groupChromPeaks -> (xcmsObj)
\item --- \emph{Older versions of XCMS} --- (mzML files) -> xcms.xcmsSet -> xcms.group -> xcms.retcor -> xcms.group -> (xcmsObj)
}
\item Fragmentation processing
\itemize{
\item (xcmsObj, pa) -> \strong{frag4feature} -> filterFragSpectra -> averageAllFragSpectra -> createDatabase -> spectralMatching -> (sqlite spectral database)
}
}
}

\subsection{Additional notes}{
\itemize{
\item If using only a single file, then grouping still needs to be performed within XCMS before frag4feature can be used.
\item Fragmentation spectra below a certain precursor ion purity can be be removed (see plim argument).
\item A SQLite database can be created directly here but the functionality has been deprecated and the createDatabase function should now be used
\item Can experience some problems when using XCMS version < 3 and obiwarp retention time correction.
}
}
}
\examples{
library(xcms)
library(MSnbase)
library(magrittr)
#====== XCMS =================================
## Read in MS data
msmsPths <- list.files(system.file("extdata", "lcms", "mzML",
           package="msPurityData"), full.names = TRUE, pattern = "MSMS")
ms_data = readMSData(msmsPths, mode = 'onDisk', msLevel. = 1)

## Find peaks in each file
cwp <- CentWaveParam(snthresh = 5, noise = 100, ppm = 10, peakwidth = c(3, 30))
xcmsObj  <- xcms::findChromPeaks(ms_data, param = cwp)

## Optionally adjust retention time
xcmsObj  <- adjustRtime(xcmsObj , param = ObiwarpParam(binSize = 0.6))

## Group features across samples
pdp <- PeakDensityParam(sampleGroups = c(1, 1), minFraction = 0, bw = 30)
xcmsObj <- groupChromPeaks(xcmsObj , param = pdp)

## Or if using the old XCMS functions
#xcmsObj <- xcms::xcmsSet(msmsPths)
#xcmsObj <- xcms::group(xcmsObj)
#xcmsObj <- xcms::retcor(xcmsObj)
#xcmsObj <- xcms::group(xcmsObj)

#====== msPurity ============================
pa <- purityA(msmsPths)
pa <- frag4feature(pa, xcmsObj)

}
