% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/purityD-dims-purity.R
\name{dimsPredictPurity,purityD-method}
\alias{dimsPredictPurity,purityD-method}
\alias{dimsPredictPurity}
\title{Using purityD object, assess anticipated purity from a DI-MS run}
\usage{
\S4method{dimsPredictPurity}{purityD}(
  Object,
  ppm = 1.5,
  minOffset = 0.5,
  maxOffset = 0.5,
  iwNorm = FALSE,
  iwNormFun = NULL,
  ilim = 0.05,
  sampleOnly = FALSE,
  isotopes = TRUE,
  im = NULL
)
}
\arguments{
\item{Object}{object = purityD object}

\item{ppm}{numeric = tolerance for target mz value in each scan}

\item{minOffset}{numeric = isolation window minimum offset}

\item{maxOffset}{numeric = isolation window maximum offset}

\item{iwNorm}{boolean = if TRUE then the intensity of the isolation window will be normalised based on the iwNormFun function}

\item{iwNormFun}{function = A function to normalise the isolation window intensity. The default function is very generalised and just accounts for edge effects}

\item{ilim}{numeric = All peaks less than this percentage of the target peak will be removed from the purity calculation, default is 5\% (0.05)}

\item{sampleOnly}{boolean = if TRUE will only calculate purity for sample peaklists}

\item{isotopes}{boolean = TRUE if isotopes are to be removed}

\item{im}{matrix = Isotope matrix, default removes C13 isotopes (single, double and triple bonds)}
}
\value{
purityD object with predicted purity of peaks

purityD object
}
\description{
Assess the precursor purity of anticpated MS/MS spectra.
i.e. it 'predicts' the precursor purity of the DI-MS peaks for a future MS/MS run.
}
\examples{

datapth <- system.file("extdata", "dims", "mzML", package="msPurityData")
inDF <- Getfiles(datapth, pattern=".mzML", check = FALSE, cStrt = FALSE)
ppDIMS <- purityD(fileList=inDF, cores=1, mzML=TRUE)
ppDIMS <- averageSpectra(ppDIMS)
ppDIMS <- filterp(ppDIMS)
ppDIMS <- subtract(ppDIMS)
ppDIMS <- dimsPredictPurity(ppDIMS)
}
\seealso{
\code{\link{dimsPredictPuritySingle}}
}
