% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evidenceToMatrix.R
\name{evidenceToMatrix}
\alias{evidenceToMatrix}
\title{Creates intensity matrix from tabular data in evidence table of MaxQuant}
\usage{
evidenceToMatrix(
  evidence,
  run_id = "Raw.file",
  peptide_id = "PeptideID",
  return_EList = FALSE,
  weights = NULL
)
}
\arguments{
\item{evidence}{data.frame. The evidence table read from evidence.txt, or data.frame created by \code{mspip}.}

\item{run_id}{character. The name of the column of evidence containing the run/raw file name.
These form the columns of the intensity data matrix.}

\item{peptide_id}{character. The name of the column of evidence containing the peptide ids.
These form the rows of the intensity data matrix.}

\item{return_EList}{logical. If TRUE, returns a \code{EListRaw} object storing both the
intensity data matrix and observation-level weights from
\code{mspip} (propagation confidence score), otherwise returns a matrix.}

\item{weights}{character. The name of the column of evidence containing weights from \code{mspip}. default to NULL.
Set this to "weight" if you want the weights from PIP stored in the \code{weights} slot of the \code{EListRaw} object.}
}
\value{
a numeric matrix of intensity data, or a \code{EListRaw} object containing
such data and observation-level weights from \code{mspip}.
}
\description{
Every \code{Modified sequence} - \code{Charge} is considered as a precursor feature.
Only the feature with maximum intensity is retained. The columns are run names, the rows
are peptide ids (in the \code{Modified.sequence_Charge} format)
}
\details{
The \code{EListRaw} object created by the function is intended to bridge \code{msImpute} and statistical
methods of \code{limma}. The object can be passed to \code{normalizeBetweenArrays} for normalisation, which can then
be passed to \code{lmFit} and \code{eBayes} for fitting linear models per peptide and Empirical Bayes moderation of t-statistics
respectively. The \code{weights} slot is recognized by \code{lmFit}, which incorporates the uncertainty in intensity values
inferred by PIP into the test statistic.
The function is also a generic tool to create a matrix or \code{limma}-compatible objects from the evidence table of MaxQuant.
}
\seealso{
mspip
}
\author{
Soroor Hediyeh-zadeh
}
