% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/KNN.R
\name{KNN}
\alias{KNN}
\title{k-nearest neighbour (KNN)}
\usage{
KNN(xorigin, ximputed, k = 3)
}
\arguments{
\item{xorigin}{numeric matrix. The original log-intensity data. Can not contain missing values.}

\item{ximputed}{numeric matrix. The imputed log-intensity data. Can not contain missing values.}

\item{k}{number of nearest neighbours. default to k=3.}
}
\value{
numeric  The proportion of preserved k-nearest neighbours in imputed data.
}
\description{
The fraction of k-nearest neighbours in the original data that are preserved as k-nearest neighbours in imputed data.
KNN quantifies preservation of the local, or microscopic structure.
Requires complete datasets - for developers/use in benchmark studies only.
}
\examples{
data(pxd007959)
y <- pxd007959$y
y <- y[complete.cases(y),]
# for demonstration we use same y for xorigin and ximputed
KNN(y, y)


}
