% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_wrapper.R
\name{simulateClumpSizeDist}
\alias{simulateClumpSizeDist}
\title{Empirical clump size distribution}
\usage{
simulateClumpSizeDist(pfm, bg, seqlen, nsim = 10, singlestranded = FALSE)
}
\arguments{
\item{pfm}{An R matrix that represents a position frequency matrix}

\item{bg}{A Background object}

\item{seqlen}{Integer-valued vector that defines the lengths of the
individual sequences. For a given DNAStringSet, 
this information can be retrieved using \code{\link{numMotifHits}}.}

\item{nsim}{Integer number of random samples.}

\item{singlestranded}{Boolean that indicates whether a single strand or
both strands shall be scanned for motif hits.
Default: singlestranded = FALSE.}
}
\value{
A List that contains
\describe{
\item{dist}{Empirical distribution of the clump sizes}
}
}
\description{
This function repeatedly simulates random DNA sequences according to
the background model and
subsequently counts the number of k-clump occurrences, where
denotes the clump size.
This function is only used for benchmarking analysis.
}
\examples{


# Load sequences
seqfile = system.file("extdata", "seq.fasta", package = "motifcounter")
seqs = Biostrings::readDNAStringSet(seqfile)

# Load background
bg = readBackground(seqs, 1)

# Load motif
motiffile = system.file("extdata", "x31.tab", package = "motifcounter")
motif = t(as.matrix(read.table(motiffile)))

# Study the clump size frequencies in one sequence of length 1 Mb
seqlen = 1000000

# scan both strands
simc = motifcounter:::simulateClumpSizeDist(motif, bg, seqlen)

# scan a single strand
simc = motifcounter:::simulateClumpSizeDist(motif, bg,
    seqlen, singlestranded = TRUE)

}
\seealso{
\code{\link{compoundPoissonDist}},\code{\link{combinatorialDist}}
}
