% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/score_wrapper.R
\name{scoreSequence}
\alias{scoreSequence}
\title{Score observations}
\usage{
scoreSequence(seq, pfm, bg)
}
\arguments{
\item{seq}{A DNAString object}

\item{pfm}{An R matrix that represents a position frequency matrix}

\item{bg}{A Background object}
}
\value{
List containing
\describe{
\item{fscores}{Vector of scores on the forward strand}
\item{rscores}{Vector of scores on the reverse strand}
}
}
\description{
This function computes the per-position and per-strand
score in a given DNA sequence.
}
\examples{


# Load sequences
seqfile = system.file("extdata", "seq.fasta", package = "motifcounter")
seqs = Biostrings::readDNAStringSet(seqfile)

# Load background
bg = readBackground(seqs, 1)

# Load motif
motiffile = system.file("extdata", "x31.tab", package = "motifcounter")
motif = t(as.matrix(read.table(motiffile)))

# Compute the per-position and per-strand scores
scoreSequence(seqs[[1]], motif, bg)

}
