% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/forground_wrapper.R
\name{revcompMotif}
\alias{revcompMotif}
\title{Reverse complements a PFM}
\usage{
revcompMotif(pfm)
}
\arguments{
\item{pfm}{An R matrix that represents a position frequency matrix}
}
\value{
Reverse complemented PFM
}
\description{
This function computes the reverse complement of a given PFM.
}
\examples{

# Load motif
motiffile = system.file("extdata", "x1.tab", package = "motifcounter")
motif = t(as.matrix(read.table(motiffile)))

# Reverse complement motif
revcompmotif = motifcounter:::revcompMotif(motif)

}
