% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/forground_wrapper.R
\name{motifValid}
\alias{motifValid}
\title{Check valididity of PFM}
\usage{
motifValid(pfm)
}
\arguments{
\item{pfm}{An R matrix that represents a position frequency matrix}
}
\value{
None
}
\description{
This function checks if the PFM is valid. The function throws
an error if the R matrix does not represent a PFM.
}
\examples{

# Load motif
motiffile = system.file("extdata", "x1.tab", package = "motifcounter")
motif = t(as.matrix(read.table(motiffile)))

# Check validity
motifcounter:::motifValid(motif)

}
