% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/markovmodel.R
\name{markovModel}
\alias{markovModel}
\title{Markov model for generating Y_1Y_2_Y3 ...}
\usage{
markovModel(overlap, nsteps = 1)
}
\arguments{
\item{overlap}{An Overlap object.}

\item{nsteps}{Number of state transitions to perform}
}
\value{
List containing
\describe{
\item{dist}{State probability distribution after the given number of steps}
}
}
\description{
This function implements the Markov model for producing
motif matches. The function takes a state probability vector
and uses the transition probabilities in order to obtain
the state probability at the next time point.
This function is used used to determine the stationary distribution
of the states.
}
\details{
The R interface is only used for the purpose of testing
the correctness of the model.
}
\examples{

# Load sequences
seqfile = system.file("extdata", "seq.fasta", package = "motifcounter")
seqs = Biostrings::readDNAStringSet(seqfile)

# Load motif
motiffile = system.file("extdata", "x31.tab", package = "motifcounter")
motif = t(as.matrix(read.table(motiffile)))

# Load background model
bg = readBackground(seqs, 1)

# Compute overlap probabilities
op = motifcounter:::probOverlapHit(motif, bg, singlestranded = FALSE)


# Computes the state probabilities of the Markov model
# (default: after one step)
dist = motifcounter:::markovModel(op)

}
\seealso{
\code{\link{compoundPoissonDist}}

\code{\link{numMotifHits}}

\code{\link{probOverlapHit}}
}
