% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/observed_wrapper.R
\name{lenSequences}
\alias{lenSequences}
\title{Length of sequences in a given fasta file}
\usage{
lenSequences(seqs)
}
\arguments{
\item{seqs}{A DNAStringSet object}
}
\value{
A vector containing the lengths of each individual sequences
}
\description{
The function returns a vector containing the lengths
of each sequence contained in a set of sequences. Sequences
containing 'N' or 'n' are skipped from the analysis and are
set to length zero.
}
\examples{

# Load sequences
file = system.file("extdata", "seq.fasta", package = "motifcounter")
seqs = Biostrings::readDNAStringSet(file)

# Retrieve sequence lengths
motifcounter:::lenSequences(seqs)

}
