% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scoreMotif.R
\name{exportMBbed}
\alias{exportMBbed}
\title{Export motifbreakR variants to bed file}
\usage{
exportMBbed(results, file, name = NULL, color = "effect_size")
}
\arguments{
\item{results}{The output of \code{\link{motifbreakR}}}

\item{file}{Character; the file name of the destination file}

\item{name}{Character; name for the BED track, defaults to "motifbreakR results"}

\item{color}{Character; one of ref_sig (\code{Refpvalue}), alt_sig
(\code{Altpvalue}), best_sig (lowest between \code{Refpvalue} and
\code{Altpvalue}), (each of which require pre-computation of p-values with
\code{\link{calculatePvalue}}), or ref_score (\code{pctRef}), alt_score
(\code{pctAlt}), best_score (highest between \code{pctRef} and \code{pctAlt}),
or the default value of effect_size (\code{alleleDiff}).}
}
\value{
\code{exportMBbed} produces an output BED file, with diverging color
scale for effect_size (blue representing stronger binding in \code{REF}, red
representing stronger binding in \code{ALT}), or a sequential color scale
otherwise (low values as purple, high values as yellow). The score column is
either the effect_size (\code{alleleDiff} column), the -log10(p-value)
(capped at 10), corresponding to \code{Refpvalue}, \code{Altpvalue}, or the
best match of the two, or the score \code{pctRef}, \code{pctAlt}, or the
highest match of the two. The name column is formatted
\code{SNP_id:REF/ALT:providerId}. Additionally a color key is returned
indicating the range of values for each color output.
}
\description{
Export motifbreakR variants to bed file
}
\examples{
data(example.results)
example.results
\donttest{
exportMBbed(example.results, file = "mb_test_output.bed", color = "effect_size")
}
}
\seealso{
See \code{\link{exportMBtable}} for the function that exports the
full \code{motifbreakR} results as a tab or comma separated table file.
}
