% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pcm.R
\docType{class}
\name{pcm-class}
\alias{pcm-class}
\alias{pcm}
\alias{$,pcm-method}
\alias{$<-,pcm-method}
\alias{plot}
\alias{plot,pcm,ANY-method}
\alias{as}
\alias{coerce,pcm,matrix-method}
\alias{trimMotif}
\alias{trimMotif,pcm,numeric-method}
\alias{matrixReverseComplement}
\alias{matrixReverseComplement,pcm-method}
\alias{addBlank}
\alias{addBlank,pcm,numeric,logical-method}
\alias{getIC}
\alias{getIC,pcm,ANY-method}
\alias{pcm2pfm}
\alias{pcm2pfm,pcm,ANY-method}
\alias{pcm2pfm,matrix,ANY-method}
\alias{pcm2pfm,matrix,numeric-method}
\alias{pcm2pfm,data.frame,ANY-method}
\alias{pcm2pfm,data.frame,numeric-method}
\alias{pcm2pfm,list,ANY-method}
\alias{pcm2pfm,list,numeric-method}
\alias{pcm2pssm}
\alias{pcm2pssm,pcm,ANY-method}
\alias{pcm2pssm,matrix,ANY-method}
\alias{pcm2pssm,matrix,numeric-method}
\alias{pcm2pssm,data.frame,ANY-method}
\alias{pcm2pssm,data.frame,numeric-method}
\alias{pcm2pssm,list,ANY-method}
\alias{pcm2pssm,list,numeric-method}
\alias{as.data.frame,pcm-method}
\alias{format,pcm-method}
\title{Class \code{"pcm"}}
\usage{
\S4method{$}{pcm}(x, name)

\S4method{plot}{pcm,ANY}(x, y = "missing", ...)

trimMotif(x, t)

matrixReverseComplement(x)

addBlank(x, n, b)

getIC(x, p)

pcm2pfm(x, background)

pcm2pssm(x, background)

\S4method{as.data.frame}{pcm}(x, row.names = NULL, optional = FALSE, ...)

\S4method{format}{pcm}(x, ...)
}
\arguments{
\item{x}{An object of class \code{pcm}. For \code{getIC}, if parameter p is
followed, x should be an object of matrix.  For \code{pcm2pfm}, x also could
be an object of matrix.}

\item{name}{slot name of pcm object.}

\item{y}{Not use.}

\item{\dots}{Further potential arguments passed to \code{plotMotifLogo}.}

\item{t}{numeric value of information content threshold for trimming.}

\item{n}{how many spaces should be added.}

\item{b}{logical value to indicate where the space should be added.}

\item{p}{p is the background frequency.}

\item{background}{a \code{"numeric"} vector. The background frequency.}

\item{row.names, optional}{see as.data.frame}
}
\description{
An object of class \code{"pcm"} represents the position count matrix of a
DNA/RNA/amino-acid sequence motif. The entry stores a matrix, which in row
i, column j gives the counts of observing nucleotide/or amino acid i in
position j of the motif.

methods for pcm objects.
}
\section{Objects from the Class}{
 Objects can be created by calls of the form
\code{new("pcm", mat, name, alphabet, color, background)}.
}

\section{Methods}{
 \describe{ \item{addBlank}{\code{signature(x="pcm",
n="numeric", b="logical")} add space into the position count matrix for
alignment. b is a bool value, if TRUE, add space to the 3' end, else add
space to the 5' end. n indicates how many spaces should be added.}

\item{coerce}{\code{signature(from = "pcm", to = "matrix")}: convert object
pcm to matrix }

\item{getIC}{\code{signature(x = "pcm",)} Calculate information content
profile for position frequency matrix. }

\item{matrixReverseComplement}{\code{signature(x = "pcm")} get the reverse
complement of position frequency matrix.}

\item{plot}{\code{signature(x = "pcm")} Plots the sequence logo of the
position count matrix. }

\item{trimMotif}{\code{signature(x = "pcm", t= "numeric")} trim motif by
information content. }

\item{$, $<-}{Get or set the slot of \code{\link{pcm-class}}}

\item{as.data.frame}{convert \code{\link{pcm-class}} to a data.frame}
\item{format}{return the name_pcm of \code{\link{pcm-class}}} }
}

\examples{

pcm <- read.table(file.path(find.package("motifStack"), "extdata", "bin_SOLEXA.pcm"))
pcm <- pcm[,3:ncol(pcm)]
rownames(pcm) <- c("A","C","G","T")
motif <- new("pcm", mat=as.matrix(pcm), name="bin_SOLEXA")
plot(motif)
pcm2pfm(pcm)
pcm2pssm(pcm)

pcm <- read.table(file.path(find.package("motifStack"), "extdata", "bin_SOLEXA.pcm"))
pcm <- pcm[,3:ncol(pcm)]
rownames(pcm) <- c("A","C","G","T")
motif <- new("pcm", mat=as.matrix(pcm), name="bin_SOLEXA")
getIC(motif)
matrixReverseComplement(motif)
as(motif,"matrix")
pcm2pfm(motif)
as.data.frame(motif)
format(motif)

}
\keyword{classes}
