% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{set_bicluster_names,bicluster,matrix-method}
\alias{set_bicluster_names,bicluster,matrix-method}
\title{Add row-/colnames to a bicluster object.}
\usage{
\S4method{set_bicluster_names}{bicluster,matrix}(bic, m)
}
\arguments{
\item{bic}{A bicluster object.}

\item{m}{The matrix, that was used for the
biclustering. (Works only if matrix has row-/colnames.)}
}
\value{
The updated bicluster object.

#' @examples
m <- matrix(c(1,2,3,4), nrow=2)
rownames(m) <- c("r1", "r2")
rownames(m) <- c("c1", "c2")
set_bicluster_names(bicluster(row=c(1,2), column=c(1,2)), m)
}
\description{
Add row-/colnames to a bicluster object.
}
