% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{network_edge_strength_float}
\alias{network_edge_strength_float}
\title{Count edges in an adjacency matrix using different cut-off 
thresholds.}
\usage{
network_edge_strength_float(adjm, steps = 100L, maximum = 0)
}
\arguments{
\item{adjm}{A symmetrix numeric matrix.}

\item{steps}{Number of steps for which the edge count is evaluated.}

\item{maximum}{Highest value until which the edge weight is evaluated. 
If maximum=0, the max value of \code{adjm} is used.}
}
\value{
A numeirc matrix of \code{dim(max(adjm), 2)}. 
The first column indicated the applied threshold, the second 
column the remaining edges.
}
\description{
Same as \code{\link{network_edge_strength}}, but for (positive) 
non-integer matrices.
}
\details{
Computes the how many edges remain in a network if edges with a 
weight lower than a certain threshold are removed.
The number of remaining edges between 1 and max(adjm) are calculated.
It is assumend that the matrix is symmetric and therefore 
the number of edges divided by two.
Uses the function \code{\link{replace_values_float}}.
}
\examples{
m <- matrix(seq(1:16), nrow=4)
# m <- matrix(rnorm(10000), nrow=100)
# bics <- c(run_fabia(m), run_isa(m), run_plaid(m))
# bn <- bicluster_network(bics, m)
# network_edge_strength_float(apply_threshold(bn))

}
