% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bicluster_net_methods.R
\name{get_louvain_communities,cooccurrence_net-method}
\alias{get_louvain_communities,cooccurrence_net-method}
\title{Get louvain communities from a co-occurrence network}
\usage{
\S4method{get_louvain_communities}{cooccurrence_net}(bic_net, min_size = 2, bics = NULL)
}
\arguments{
\item{bic_net}{A \code{\link{cooccurrence_net}} object.}

\item{min_size}{Minimum size of a louvain community to be
returned (minimum value is 2).}

\item{bics}{Not used.}
}
\value{
A list of \code{\link{cooccurrence_net}} objects.
}
\description{
Extracts the louvain communities from a \code{\link{cooccurrence_net}}
object using the louvain modularity optimization from the \code{igraph}
package (\code{\link[igraph]{cluster_louvain}}).
}
\examples{
m <- matrix(seq(1:16), nrow=4)
# m <- matrix(rnorm(10000), nrow=100)
# bics <- c(run_fabia(m), run_isa(m), run_plaid(m))
# fn <- feature_network(bics, m)
# get_louvain_communities(fn)

}
