% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_biclust.R
\name{getBiclustClusters}
\alias{getBiclustClusters}
\title{Extract a list of bicluster objects from a biclust object.}
\usage{
getBiclustClusters(
  bics,
  mat,
  method = "biclust",
  transposed = FALSE,
  filterfun = NULL,
  ...
)
}
\arguments{
\item{bics}{A biclust object.}

\item{mat}{Original matrix, that was used for biclustering.}

\item{method}{Name of the used biclustering algorithm. Should be one of
the following: "biclust", "biclust-bimax", "biclust-cc", "biclust-plaid",
"biclust-quest", "biclust-spectral", "biclust-xmotifs" or "biclust-qubic",
"biclust-unibic".}

\item{transposed}{\code{True}, if the bicluster calculation was
performed on a tranposed matrix.}

\item{filterfun}{A function to filter biclusters. Only if the function
returns \code{True}, the bicluster is added to the returned list.
The function has to accept a the bicluster (given as submatrix
of \code{mat}) \code{filterfun(bicluster_matrix, ...)}.}

\item{...}{Other parameters forwarded to the \code{filterfun}.}
}
\value{
A list of \code{\link{bicluster}} objects, which have
to be valid (See \code{\link{validate_bicluster}}.
}
\description{
Extract a list of bicluster objects from a biclust object.
}
\examples{
m <- matrix(seq(1:16), nrow=4)
# m <- matrix(rnorm(10000), nrow=100)
# res <- biclust::biclust(m, method = biclust::BCBimax())
# getBiclustClusters(res, m)

}
