% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{attribute_graph}
\alias{attribute_graph}
\title{Generate attribute specific co-occurance networks.}
\usage{
attribute_graph(bics, m, MARGIN = "column")
}
\arguments{
\item{bics}{A list of \code{\link{bicluster}}s.}

\item{m}{The matrix used for biclustering.}

\item{MARGIN}{\code{"row"} or \code{"row"}, Indicating if a list of 
row- or column-specific networks is generated}
}
\value{
A list of numeric matrices.
If \code{MARGIN="column"} (\code{"row"}), the list has a 
length of \code{ncol(m)} (\code{nrow(m)}) 
and each matrix the dimensions of \code{c(nrow(m), 
nrow(m))} (\code{c(ncol(m), ncol(m))})
}
\description{
The function generates co-occurance networks for all the attributes.
E.g. if \code{MARGIN="column"}, for each column, a oc-occurance matrix 
of rows is generated, which includes all biclusters, where the 
column element is present.
}
\examples{
m <- matrix(seq(1:16), nrow=4)
# m <- matrix(rnorm(10000), nrow=100)
# bics <- c(run_fabia(m), run_isa(m), run_plaid(m))
# attribute_graph(bics, m)

}
