% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cluster.R
\name{splines_kmeans_predict,Moanin-method}
\alias{splines_kmeans_predict,Moanin-method}
\alias{splines_kmeans_score_and_label}
\alias{splines_kmeans_predict}
\alias{splines_kmeans_score_and_label,Moanin-method}
\title{Assign score and labels from raw data}
\usage{
\S4method{splines_kmeans_predict}{Moanin}(
  object,
  kmeans_clusters,
  data = NULL,
  method = c("distance", "goodnessOfFit"),
  ...
)

\S4method{splines_kmeans_score_and_label}{Moanin}(
  object,
  kmeans_clusters,
  data = NULL,
  proportion_genes_to_label = 0.5,
  max_score = NULL,
  previous_scores = NULL,
  rescale_separately = FALSE
)
}
\arguments{
\item{object}{the Moanin object that contains the basis functions used in
creating the clusters}

\item{kmeans_clusters}{List returned by \code{\link{splines_kmeans}}}

\item{data}{the data to predict. If not given, will use \code{assay(object)}.
If given, the number of columns of \code{data} must match that of
\code{object}}

\item{method}{If "distance", predicts based on distance of data to kmeans
centroids. If "goodnessOfFit", is a wrapper to
\code{splines_kmeans_score_and_label}, assigning labels based on goodness
of fit, including any filtering.}

\item{...}{arguments passed to \code{splines_kmeans_score_and_label}}

\item{proportion_genes_to_label}{float, optional, default: 0.5
Percentage of genes to label. If max_score is provided, will label
genes that are either in the top `proportion_genes_to_label` or with a
score below `max_score`.}

\item{max_score}{optional, default: Null
When provided, will only label genes below that score. If NULL, ignore
this option.}

\item{previous_scores}{matrix of scores, optional. Allows user to give the
matrix scores results from a previous run of
\code{splines_kmeans_score_and_label}, and only redo the filtering (i.e. if
want to change \code{proportion_genes_to_label} without rerunning the
calculation of scores)}

\item{rescale_separately}{logical, whether to score separately within
grouping variable}
}
\value{
\code{splines_kmeans_predict} returns a vector giving the labels for
  the given data.

A list consisting of
\itemize{
\item{\code{labels}}{the label or cluster assigned to each gene based on the
cluster with the best (i.e. lowest) score, with no label given to genes that
do not have a score lower than a specified quantity}
\item{\code{scores}}{the matrix of size n_cluster x n_genes, containing for 
each gene and each cluster, the goodness of fit score}
\item{\code{score_cutoff}}{The required cutoff for a gene receiving an
assignment}
}
}
\description{
Assign score and labels from raw data
}
\examples{
data(exampleData)
moanin <- create_moanin_model(data=testData, meta=testMeta)
# Cluster on a subset of genes
kmClusters=splines_kmeans(moanin[1:50,],n_clusters=3)
# get scores on all genes
scores_and_labels <- splines_kmeans_score_and_label(object=moanin, kmClusters)
head(scores_and_labels$scores)
head(scores_and_labels$labels)
# should be same as above, only just the assignments
predictLabels1 <- splines_kmeans_predict(object=moanin, kmClusters, 
     method="goodnessOfFit")
# Instead use distance to centroid:
predictLabels2 <- splines_kmeans_predict(object=moanin, kmClusters, 
     method="distance")
}
